/*#* dynload.c 

   Copyright Michael Kerrisk,  Nov 00  

   Usage: dynload library-path function-name
*/
/*#**
   Change history

   DD MMM YY	Comment
*/
/*#{{*/
#define _GNU_SOURCE
/*#}*/
#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>


int
main(int argc, char *argv[])
{
    void *libHandle;		/* Handle for shared library */
    void (*funcp)(void);	/* Pointer to function with no args */
    char *err;
    
    if (argc != 3) {		/* Check command line arguments */
        fprintf(stderr, "Usage: %s lib-path func-name\n", argv[0]);
        exit(EXIT_FAILURE);
    } /* if */ 

    /* Load the shared library and get a handle for later use */
    
    libHandle = dlopen(argv[1], RTLD_LAZY);
    if (libHandle == NULL) {
	fprintf(stderr, "Error on dlopen: %s\n", dlerror());
	exit(EXIT_FAILURE);
    } /* if */

    /* Get a pointer to named function inside library */
    
    (void) dlerror();				/* Clear dlerror() */
    funcp = dlsym(libHandle, argv[2]);
    err = dlerror();	    
    if (err != NULL) {  /* Non-NULL from dlerror() means we got error */
	fprintf(stderr, "Error on dlsym: %s\n", err);
	exit(EXIT_FAILURE);
    } /* if */

/*#{{*/
    {
	Dl_info dli;
	dladdr(funcp, &dli);

	printf("Lib name = %s\n", dli.dli_fname);
	printf("Load address = 0x%lx\n", (long) dli.dli_fbase);
	printf("Name of nearest sym = %s\n", dli.dli_sname);
	printf("Load address = 0x%lx\n", (long) dli.dli_saddr);
    }
/*#}*/

    /* If the function address is non-NULL try calling it */

    if (funcp == NULL)
	printf("%s is NULL\n", argv[2]);
    else
        (*funcp)();

    /* And close the library */

    dlclose(libHandle);

    exit(EXIT_SUCCESS);
} /* main */
